/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioSample;
import ddf.minim.Minim;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public class flowG_pde
extends PApplet {
    private static final long serialVersionUID = 1L;
    Minim minim;
    AudioSample soundJ;
    AudioSample soundK;
    AudioSample soundL;
    AudioSample soundM;
    AudioSample soundD;
    AudioSample soundF;
    AudioSample soundB;
    AudioSample soundC;
    PImage img1;
    PImage img2;
    PImage img3;
    PImage img4;
    PImage img5;
    PImage img6;
    PImage img7;
    PImage img8;
    int frameCounter;
    public static final int ARRAY_LENGTH = 100;
    PImage[] imageArray = new PImage[8];
    AudioSample[] audioArray = new AudioSample[8];
    int[] audioBlock = new int[100];
    int[] videoBlock = new int[100];
    PFont font;
    int n;
    int score;
    int trialCount;
    int trialLength;
    boolean isThereAPair;
    boolean listen;
    int mode;

    public void setup() {
        this.size(300, 300);
        this.font = this.createFont("FFScala", 16.0f);
        this.initialiseVariables();
        this.minim = new Minim((PApplet)this);
        String dataDirectory = ".\\data\\";
        this.audioArray[0] = this.minim.loadSample(String.valueOf(dataDirectory) + "j.wav");
        this.audioArray[1] = this.minim.loadSample(String.valueOf(dataDirectory) + "k.wav");
        this.audioArray[2] = this.minim.loadSample(String.valueOf(dataDirectory) + "l.wav");
        this.audioArray[3] = this.minim.loadSample(String.valueOf(dataDirectory) + "m.wav");
        this.audioArray[4] = this.minim.loadSample(String.valueOf(dataDirectory) + "b.wav");
        this.audioArray[5] = this.minim.loadSample(String.valueOf(dataDirectory) + "d.wav");
        this.audioArray[6] = this.minim.loadSample(String.valueOf(dataDirectory) + "c.wav");
        this.audioArray[7] = this.minim.loadSample(String.valueOf(dataDirectory) + "f.wav");
        this.imageArray[0] = this.loadImage(String.valueOf(dataDirectory) + "image1.jpg");
        this.imageArray[1] = this.loadImage(String.valueOf(dataDirectory) + "image2.jpg");
        this.imageArray[2] = this.loadImage(String.valueOf(dataDirectory) + "image3.jpg");
        this.imageArray[3] = this.loadImage(String.valueOf(dataDirectory) + "image4.jpg");
        this.imageArray[4] = this.loadImage(String.valueOf(dataDirectory) + "image5.jpg");
        this.imageArray[5] = this.loadImage(String.valueOf(dataDirectory) + "image6.jpg");
        this.imageArray[6] = this.loadImage(String.valueOf(dataDirectory) + "image7.jpg");
        this.imageArray[7] = this.loadImage(String.valueOf(dataDirectory) + "image8.jpg");
        this.loop();
        this.frameRate(2.0f);
        this.frameCounter = 0;
    }

    public void initialiseVariables() {
        this.n = 2;
        this.score = 0;
        this.trialCount = 0;
        this.trialLength = 30;
        this.isThereAPair = false;
        this.listen = true;
        this.mode = 1;
    }

    public void draw() {
        switch (this.mode) {
            case 1: {
                this.drawMode1();
                break;
            }
            case 2: {
                this.drawMode2();
            }
        }
    }

    public void drawMode2() {
        this.background(this.color(0, 0, 255));
        this.textFont(this.font);
        this.text("You scored:" + Integer.toString(this.score), 10.0f, 50.0f);
    }

    public void drawMode1() {
        this.background(this.color(0, 0, 255));
        if (this.trialCount <= this.trialLength + this.n && this.frameCounter == 0) {
            this.listen = true;
            if (this.trialCount == 0) {
                this.initialiseBlock();
            }
            System.out.print(String.valueOf(this.trialCount) + "\n");
            ++this.trialCount;
            this.textFont(this.font);
            this.image(this.imageArray[this.videoBlock[this.trialCount - 1]], 100.0f, 100.0f);
            this.audioArray[this.audioBlock[this.trialCount - 1]].trigger();
            this.isThereAPair = this.trialCount >= this.n + 1 && (this.audioBlock[this.trialCount - 1] == this.audioBlock[this.trialCount - (1 + this.n)] || this.videoBlock[this.trialCount - 1] == this.videoBlock[this.trialCount - (1 + this.n)]);
        }
        this.text("Trial: " + Integer.toString(this.trialCount - 1), 10.0f, 280.0f);
        this.text("Score: " + Integer.toString(this.score), 100.0f, 280.0f);
        this.text("pairs: " + Integer.toString(this.countPairs()), 190.0f, 280.0f);
        ++this.frameCounter;
        if (this.frameCounter > 5) {
            this.frameCounter = 0;
            if (this.trialCount >= this.trialLength) {
                this.mode = 2;
            }
        }
    }

    public int doExit() {
        this.exit();
        return 0;
    }

    public void keyPressed() {
        switch (this.mode) {
            case 1: {
                if (!this.listen) break;
                this.listen = false;
                if (this.isThereAPair) {
                    ++this.score;
                    flowG_pde.print((String)("score! " + this.score + "\n"));
                    break;
                }
                --this.score;
                flowG_pde.print((String)("wrong! " + this.score + "\n"));
            }
        }
    }

    public int countPairs() {
        int pCount = 0;
        int i = this.n;
        while (i < this.trialLength + this.n) {
            if (this.audioBlock[i - this.n] == this.audioBlock[i] || this.videoBlock[i - this.n] == this.videoBlock[i]) {
                ++pCount;
            }
            flowG_pde.println();
            ++i;
        }
        return pCount;
    }

    public void initialiseBlock() {
        this.fillAudioAndVideoBlockWith999();
        this.addCollidingTargets();
        this.addTargetsToAudio();
        this.addTargetsToVideoNonCollide();
        this.populateBlocksWithNonTargets();
        this.pairCount(this.videoBlock, this.n, "video");
        this.pairCount(this.audioBlock, this.n, "audio");
        System.out.println(this.countPairs());
    }

    public void addTargetsToAudio() {
        int i = 0;
        while (i < 4) {
            boolean found = false;
            while (!found) {
                int x = PApplet.parseInt((float)this.random(this.trialLength));
                if (this.audioBlock[x] != 999 || this.audioBlock[x + this.n] != 999) continue;
                boolean nopair = false;
                while (!nopair) {
                    int y = PApplet.parseInt((float)this.random(8.0f));
                    int[] tempArray = (int[])this.audioBlock.clone();
                    if (x >= this.n && (this.audioBlock[x - this.n] == y || this.audioBlock[x + 2 * this.n] == y)) continue;
                    tempArray[x] = y;
                    tempArray[x + this.n] = y;
                    if (this.pairCount(tempArray, this.n, "") != this.pairCount(this.audioBlock, this.n, "") + 1) continue;
                    this.audioBlock = tempArray;
                    nopair = true;
                }
                found = true;
            }
            ++i;
        }
    }

    public void addTargetsToVideoNonCollide() {
        int i = 0;
        while (i < 4) {
            boolean found = false;
            while (!found) {
                int x = PApplet.parseInt((float)this.random(this.trialLength));
                if (this.videoBlock[x] != 999 || this.videoBlock[x + this.n] != 999 || this.audioBlock[x] != 999 && this.audioBlock[x] == this.audioBlock[x + this.n]) continue;
                boolean nopair = false;
                int[] tempArray = (int[])this.videoBlock.clone();
                while (!nopair) {
                    int y = PApplet.parseInt((float)this.random(8.0f));
                    if (x >= this.n && (this.videoBlock[x - this.n] == y || this.videoBlock[x + 2 * this.n] == y)) continue;
                    tempArray[x] = y;
                    tempArray[x + this.n] = y;
                    if (this.pairCount(tempArray, this.n, "") != this.pairCount(this.videoBlock, this.n, "") + 1) continue;
                    this.videoBlock = tempArray;
                    nopair = true;
                }
                found = true;
            }
            ++i;
        }
    }

    public void fillAudioAndVideoBlockWith999() {
        int i = 0;
        while (i < this.videoBlock.length) {
            this.videoBlock[i] = 999;
            this.audioBlock[i] = 999;
            ++i;
        }
    }

    public void populateBlocksWithNonTargets() {
        int y;
        boolean found;
        int i = 0;
        while (i < this.trialLength + this.n) {
            if (this.videoBlock[i] == 999) {
                found = false;
                while (!found) {
                    y = PApplet.parseInt((float)this.random(8.0f));
                    if (y == this.videoBlock[i + this.n] || i >= this.n && y == this.videoBlock[i - this.n]) continue;
                    this.videoBlock[i] = y;
                    found = true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.trialLength + this.n) {
            if (this.audioBlock[i] == 999) {
                found = false;
                while (!found) {
                    y = PApplet.parseInt((float)this.random(8.0f));
                    if (y == this.audioBlock[i + this.n] || i >= this.n && y == this.audioBlock[i - this.n]) continue;
                    this.audioBlock[i] = y;
                    found = true;
                }
            }
            ++i;
        }
    }

    public void addCollidingTargets() {
        int i = 0;
        while (i < 2) {
            boolean found = false;
            while (!found) {
                int x = PApplet.parseInt((float)this.random(this.trialLength));
                if (this.videoBlock[x] != 999 || this.videoBlock[x + this.n] != 999 || this.audioBlock[x] != 999 || this.audioBlock[x + this.n] != 999) continue;
                found = true;
                boolean nopair = false;
                while (!nopair) {
                    int p = PApplet.parseInt((float)this.random(8.0f));
                    int q = PApplet.parseInt((float)this.random(8.0f));
                    if (p == this.audioBlock[x + 2 * this.n] || x >= this.n && p == this.audioBlock[x - this.n] || q == this.videoBlock[x + 2 * this.n] || x >= this.n && q == this.videoBlock[x - this.n]) continue;
                    this.audioBlock[x] = p;
                    this.audioBlock[x + this.n] = p;
                    this.videoBlock[x] = q;
                    this.videoBlock[x + this.n] = q;
                    nopair = true;
                }
            }
            ++i;
        }
    }

    public int pairCount(int[] array, int offset, String label) {
        int count = 0;
        int i = 0;
        while (i < this.trialLength) {
            if (array[i] != 999 && array[i] == array[i + offset]) {
                if (label.compareTo("") != 0) {
                    System.out.print(i);
                    System.out.print(" and ");
                    System.out.print(i + offset);
                    System.out.print(" are a " + label + " pair. (" + array[i] + ")\n");
                }
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void stop() {
        int i = 0;
        while (i < 8) {
            this.audioArray[i].close();
            ++i;
        }
        this.minim.stop();
        super.stop();
    }

    public static void main(String[] args) {
        PApplet.main((String[])new String[]{"--bgcolor=#ece9d8", "flowG_pde"});
    }
}

